#!/usr/bin/perl

######################################################################
##                                                                  ##
## YourShop IDTracker - Copyright SunnyScript - All rights reserved ##
## SunnyScript is a subsidiary of Star Enterprise                   ##
##                                                                  ##
## Legal agreements... http://www.sunnyscript.com/terms.htm         ##
## Visit our website... http://www.sunnyscript.com                  ##
##                                                                  ##
######################################################################
##                                                                  ##
## CONFIGURATION:                                                   ##
##                                                                  ##
## 1. Look to the first line and replace /usr/bin/perl with your    ##
## path to Perl (ask your provider if you don't know where Perl is  ##
## located on the server).                                          ##
##                                                                  ##
## 2. Edit the variable cgipath to point to script.cgi that is on   ##
## the server (URL) where the cookie will be accessed later.        ##
## If this is a SSL server, please type http instead of https, but  ##
## use the same domain.                                             ##
##                                                                  ##
## Call this script as SSI. You may need to configure your server   ##
## to use server side includes (SSI). Ask your provider for more    ##
## information about SSI.                                           ##
##                                                                  ##
## Read manual.htm for detailed information.                        ##
##                                                                  ##
######################################################################

$cgipath = "http://starenterprise.com/cgi-bin/script.cgi";

######################################################################
##                                                                  ##
## Don't change anything below this line. It may cause errors.      ##
##                                                                  ##
######################################################################

%input = &User_Data();

print "Content-type: text/plain\n\n<img src=\"";
print $cgipath;
print "?id=$input{'id'}\">\n";
exit;

sub User_Data {
  local (%user_data, $user_string, $name_value_pair, @name_value_pairs, $name, $value);

  if ($ENV{'REQUEST_METHOD'} eq "POST") {
    read(STDIN,$user_string,$ENV{'CONTENT_LENGTH'});
  } else {
    $user_string = $ENV{'QUERY_STRING'};
  }

  $user_string =~ s/\+/ /g;

  @name_value_pairs = split(/&/, $user_string);

  foreach $name_value_pair (@name_value_pairs) {
    ($name, $value) = split(/=/, $name_value_pair);

    $name =~
      s/%([a-fA-F0-9][a-fA-F0-9])/pack("C",hex($1))/ge;
    $value =~
      s/%([a-fA-F0-9][a-fA-F0-9])/pack("C",hex($1))/ge;

    if (defined($user_data{$name})) {
      $user_data{$name} .= ":" . $value;
    } else {
      $user_data{$name} = $value;
    }
  }
  return %user_data;
}
